
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

//#define FPS

using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Media;

using GE.Visualisation;
using GE.Input;
using GE.World;
using GE.World.Entities;
using GE.Manager;
using GE.TimeClock;
using GE.Gui.Hud;
using GE.Audio;
using GE.Gui;

namespace Vegapunk
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;


#if DEBUG && FPS
        int _iFPS;
        int _iLastSecond;
#endif

        public Game()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            Window.Title = "Megaman Zero - Florent DEVILLECHABROL";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            //Initialise all the singleton
            GameWrapper.Instance.TheGame = this;
            Visu.Instance.init(this);
            World.Instance.init(Content);
            Gui.Instance.Content = Content;
            Input.Instance.init(Content.RootDirectory + "\\Controls\\controls.xml", 1);
            Input.Instance.Mode = InputMode.Game;
            HeadUpDisplay.Instance.init();
            FontManager.Instance.init(Content);
            Audio.Instance.init(Content);
            base.Initialize();

#if DEBUG && FPS
            _iFPS = 0;
            _iLastSecond = GE.TimeClock.Clock.instance.millisecs;
#endif

        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            //load the animations
            Visu.Instance.loadAnimations("animations.xml");

            //load the sounds
            SoundEffectInstance newSound = Audio.Instance.loadSound("menuBackground", "Audio\\Shinedown_DiamondEyes");
            newSound.IsLooped = true;
            GE.Audio.Playlist gamePlaylist = Audio.Instance.createPlaylist();
            newSound = Audio.Instance.loadSound("background1", "Audio\\Back in Black");
            gamePlaylist.addSound(newSound);
            newSound = Audio.Instance.loadSound("background2", "Audio\\Iron Man");
            gamePlaylist.addSound(newSound);
            World.Instance.GamePlaylist = gamePlaylist;

        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            Input.Instance.update();

            Gui.Instance.update();
            World.Instance.update();
            Audio.Instance.update();

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
#if DEBUG && FPS
            _iFPS++;
            if (GE.TimeClock.Clock.instance.millisecs >= _iLastSecond + 1000)
            {
                _iLastSecond = GE.TimeClock.Clock.instance.millisecs;
                //System.Console.Write(_iFPS);
                System.Diagnostics.Debug.WriteLine(_iFPS.ToString());
                _iFPS = 0;
            }
#endif        
            Visu.Instance.preRender(false);
            if (!Visu.Instance.Error)
            {
                World.Instance.render();
                Gui.Instance.render();
                Visu.Instance.postRender();
            }

            base.Draw(gameTime);
        }
    }
}
